* Definica indexovych mnozin
Set i /1*10/
    k /1*5000/
    n /1*1000/
    w1 /RAS,OLD/,
    w2 /A,B,C,D,E,F/;

alias(i,j);

* Definicia parametrov
Parameter A1(i,j),B1(i,j),y1(i),x1(j),u1(i),v1(j),
          A0(i,j),B0(i,j),y0(i),x0(j),u0(i),v0(j),
          MAD_A(n,w1,w2),SEM_A(n,w1,w2),
          MAD_B(n,w1,w2),SEM_B(n,w1,w2),
          GOF_A(n,w1,w2),GOF_B(n,w1,w2),
          CORR_A(n,w1,w2),CORR_B(n,w1,w2),
          MaxPE(n,w1,w2),MAPE(n,w1,w2),
          mean0,mean1,stddev0,stddev1;

Scalar G,N1,N2;

    N1=sum((i,j), 1);
    N2=sum(n, 1);

Parameter A1_HAT(i,j,w1),B1_HAT(i,j,w1),
          R(i),S(j),
          E_A(i,j,w1),
          E_B(i,j,w1),
          P_B(i,j,w1),
          mean_A1_HAT(w1),mean_B1_HAT(w1),
          mean_A1,mean_B1;

Parameter e(w2);
    e('A')=0.01;
    e('B')=0.005;
    e('C')=0.001;
    e('D')=0.0005;
    e('E')=0.0001;

*loop(k,
*    B0(i,j)=uniform(0,10);
*    y0(i)=uniform(0,10);
*    B1(i,j)=abs(normal(1.3,0.85))*B0(i,j);
*    y1(i)=abs(normal(1.3,0.85))*y0(i);
*    );

* MC simulacie
loop(n,

    B0(i,j)=uniform(0,10);
    y0(i)=uniform(0,10);
    u0(i)=sum(j, B0(i,j));
    v0(j)=sum(i, B0(i,j));

    x0(i)=u0(i)+y0(i);

    loop(i,
         if (v0(i)>=x0(i),
            x0(i)=v0(i)+y0(i);
            y0(i)=x0(i)-u0(i);
            );
         );

    A0(i,j)=B0(i,j)/x0(j);

    B1(i,j)=abs(normal(1.3,0.05))*B0(i,j);
    y1(i)=abs(normal(1.3,0.05))*y0(i);
    u1(i)=sum(j, B1(i,j));
    v1(j)=sum(i, B1(i,j));

    x1(i)=u1(i)+y1(i);
    loop(i,
         if (v1(i)>=x1(i),
            x1(i)=v1(i)+y1(i);
            y1(i)=x1(i)-u1(i);
            );
         );

    A1(i,j)=B1(i,j)/x1(j);

    loop(w2,

         A1_HAT(i,j,w1)=A0(i,j);

         while(
                smax(i, abs(u1(i)-sum(j, A1_HAT(i,j,'RAS')*x1(j))))>e(w2)
             or smax(j, abs(v1(j)/x1(j)-sum(i, A1_HAT(i,j,'RAS'))))>e(w2),

             if (smax(i, abs(u1(i)-sum(j, A1_HAT(i,j,'RAS')*x1(j))))>e(w2),
                 R(i)=u1(i)/sum(j, A1_HAT(i,j,'RAS')*x1(j));
                 loop(j, A1_HAT(i,j,'RAS')=A1_HAT(i,j,'RAS')*R(i));
                 )
             if (smax(j, abs(v1(j)/x1(j)-sum(i, A1_HAT(i,j,'RAS'))))>e(w2),
                 S(j)=v1(j)/x1(j)/sum(i, A1_HAT(i,j,'RAS'));
                 loop(i, A1_HAT(i,j,'RAS')=A1_HAT(i,j,'RAS')*S(j));
                 )
              );

         B1_HAT(i,j,w1)=A1_HAT(i,j,w1)*x1(j);

         E_A(i,j,w1) = A1_HAT(i,j,w1)-A1(i,j);
         E_B(i,j,w1) = B1_HAT(i,j,w1)-B1(i,j);
         P_B(i,j,w1)$B1(i,j) = abs(E_B(i,j,w1))/B1(i,j);

         MAD_A(n,w1,w2) = sum((i,j), abs(E_A(i,j,w1)))/N1;
         SEM_A(n,w1,w2) = sum((i,j), power(E_A(i,j,w1),2))/N1;

         MAD_B(n,w1,w2) = sum((i,j), abs(E_B(i,j,w1)))/N1;
         SEM_B(n,w1,w2) = sum((i,j), power(E_B(i,j,w1),2))/N1;

         MaxPE(n,w1,w2) = smax((i,j), P_B(i,j,w1));
         MAPE(n,w1,w2) = sum((i,j), P_B(i,j,w1))/N1;

       GOF_A(n,w1,w2) = sum((i,j), E_A(i,j,w1)*E_A(i,j,w1)/(N1*A1_HAT(i,j,w1)));
       mean_A1_HAT(w1)=sum((i,j), A1_HAT(i,j,w1))/N1;
       mean_A1=sum((i,j), A1(i,j))/N1;
       CORR_A(n,w1,w2) = (sum((i,j),(A1_HAT(i,j,w1)-mean_A1_HAT(w1))*(A1(i,j)-mean_A1))/N1)/
         ((sum((i,j),power(A1_HAT(i,j,w1)-mean_A1_HAT(w1),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5;

       GOF_B(n,w1,w2) = sum((i,j), E_B(i,j,w1)*E_B(i,j,w1)/(N1*B1_HAT(i,j,w1)));
       mean_B1_HAT(w1)=sum((i,j), B1_HAT(i,j,w1))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B(n,w1,w2) = (sum((i,j),(B1_HAT(i,j,w1)-mean_B1_HAT(w1))*(B1(i,j)-mean_B1))/N1)/
         ((sum((i,j),power(B1_HAT(i,j,w1)-mean_B1_HAT(w1),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5;

    mean0(n)=sum((i,j), b0(i,j))/N1;
    mean1(n)=sum((i,j), b1(i,j))/N1;
    stddev0(n)=sum((i,j), power((b0(i,j)-mean0(n)),2))/N1;
    stddev1(n)=sum((i,j), power((b1(i,j)-mean1(n)),2))/N1;

        );
   );

* vypocet parametrov
Parameter MAD_A_AVG(w1,w2),SEM_A_AVG(w1,w2),
          MAD_B_AVG(w1,w2),SEM_B_AVG(w1,w2),
          MaxPE_AVG(w1,w2),MAPE_AVG(w1,w2),
          GOF_A_AVG(w1,w2),GOF_B_AVG(w1,w2),
          CORR_A_AVG(w1,w2),CORR_B_AVG(w1,w2),
          mean0_avg,mean1_avg,
          stddev0_avg,stddev1_avg;

   MAD_A_AVG(w1,w2)=sum(n, MAD_A(n,w1,w2))/N2;
   SEM_A_AVG(w1,w2)=sum(n, SEM_A(n,w1,w2))/N2;

   MAD_B_AVG(w1,w2)=sum(n, MAD_B(n,w1,w2))/N2;
   SEM_B_AVG(w1,w2)=sum(n, SEM_B(n,w1,w2))/N2;

   MaxPE_AVG(w1,w2)=sum(n, MaxPE(n,w1,w2))/N2;
   MAPE_AVG(w1,w2)=sum(n, MAPE(n,w1,w2))/N2;

   GOF_A_AVG(w1,w2)=sum(n, GOF_A(n,w1,w2))/N2;
   CORR_A_AVG(w1,w2)=sum(n, CORR_A(n,w1,w2))/N2;

   GOF_B_AVG(w1,w2)=sum(n, GOF_B(n,w1,w2))/N2;
   CORR_B_AVG(w1,w2)=sum(n, CORR_B(n,w1,w2))/N2;

   mean0_avg=sum(n, mean0(n))/N2;
   mean1_avg=sum(n, mean1(n))/N2;

   stddev0_avg=sum(n, stddev0(n))/N2;
   stddev1_avg=sum(n, stddev1(n))/N2;

option decimals = 5

Display MAD_A_AVG,SEM_A_AVG,
        MAD_B_AVG,SEM_B_AVG,
        MaxPE_AVG,MAPE_AVG,
        GOF_A_AVG,GOF_B_AVG,
        CORR_A_AVG,CORR_B_AVG,
        mean0_avg,mean1_avg,
        stddev0_avg,stddev1_avg;